#ifndef _ReplicationDlg_CPP
#define _ReplicationDlg_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.h>

#include "../Resources/Resource.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedClasses/CStatusDlg/CStatusDlg.H"
#include "../../SharedSource/NSWFL.H"

#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/Replication.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/SplashDlg.H"
#include "../Dialogs/ReplicationDlg.H"
#include "../Dialogs/RepIssues.H"
#include "../Dialogs/PendingTrans.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND Replication_hWnd = NULL;

HWND TablesList_hWnd = NULL;

bool bProcessing = false;

DWORD WINAPI ProcessTablesGrid_Thread(LPVOID lpData);
HANDLE ProcessTablesGrid_Thread_Handle = NULL;
DWORD ProcessTablesGrid_Thread_ID = 0;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK ReplicationDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

	static HIMAGELIST hImgList;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG)
    {
        Replication_hWnd = xHandle;

        char sCaption[1024];
		sprintf(sCaption, "%s :: %s", gsTitleCaption, "Replication");
        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)sCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_TRAYICON)) );

		LV_COLUMN MyLVColumb;
		memset(&MyLVColumb, 0, sizeof(MyLVColumb));

		TablesList_hWnd = GetDlgItem(xHandle, IDC_TALBES);

		// Create Listview columbs
        MyLVColumb.cx        = 300;
        MyLVColumb.pszText   = "Table Name";
        MyLVColumb.iSubItem  = 0;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(TablesList_hWnd, 0, &MyLVColumb);

        MyLVColumb.cx        = 150;
        MyLVColumb.pszText   = "Primary Key";
        MyLVColumb.iSubItem  = 1;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(TablesList_hWnd, 1, &MyLVColumb);

        MyLVColumb.cx        = 300;
        MyLVColumb.pszText   = "Status";
        MyLVColumb.iSubItem  = 2;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(TablesList_hWnd, 2, &MyLVColumb);

		hImgList = ImageList_Create(GetSystemMetrics(SM_CXSMICON), GetSystemMetrics(SM_CYSMICON), TRUE, 1, 1);

		HICON hIcon = NULL;
		
        hIcon = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_AVAILFORREP));
        ImageList_AddIcon(hImgList, (HICON)hIcon);
        DeleteObject((HICON)hIcon);

        hIcon = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_NOTAVAILFORREP));
        ImageList_AddIcon(hImgList, (HICON)hIcon);
        DeleteObject((HICON)hIcon);

        hIcon = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_REPLICATING));
        ImageList_AddIcon(hImgList, (HICON)hIcon);
        DeleteObject((HICON)hIcon);

        ListView_SetImageList(TablesList_hWnd, hImgList, LVSIL_SMALL);

		PopTablesGrid(TablesList_hWnd);

		CenterWindow(xHandle);

        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {
		if(wParam == ID_PENDINGTRANSACTIONS)
        {
			//DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_REPISSUES), xHandle, RepIssuesDialog);
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_PENDINGTRANS), xHandle, PendingTransDialog);
			return TRUE;
		}

		if(wParam == ID_CHKALL)
        {
			CheckGridRows(TablesList_hWnd, true);
			return TRUE;
		}

        if(wParam == ID_CHKNONE)
        {
			CheckGridRows(TablesList_hWnd, false);
			return TRUE;
		}

		if(wParam == ID_APPLY)
        {
			bProcessing = true;
			ProcessTablesGrid_Thread_Handle = CreateThread(NULL, 0 ,ProcessTablesGrid_Thread, (LPVOID)0, 0, &ProcessTablesGrid_Thread_ID);

			int iLVStyle = LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT;
			SendMessage(TablesList_hWnd, (UINT)LVM_SETEXTENDEDLISTVIEWSTYLE, (WPARAM)0, (LPARAM)iLVStyle);

			return TRUE;
        }

        if(wParam == ID_CANCEL)
        {
			EndDialog(xHandle,0);
			DestroyWindow(xHandle);
			return TRUE;
        }
		
		return FALSE;
    }

	//--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE) 
    {
        if(bProcessing)
		{
			MessageBox(xHandle, "Please wait until the process is complete.", gsTitleCaption, NULL);
		}
		else{
			EndDialog(xHandle,0);
			DestroyWindow(xHandle);
		}
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CheckGridRows(HWND Grid_hWnd, bool bCheck)
{
	int iRow = 0;
	int iItems = ListView_GetItemCount(Grid_hWnd);

	while(iRow < iItems)
    {
		ListView_SetCheckState(Grid_hWnd, iRow, (BOOL) bCheck);
		iRow++;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool PopTablesGrid(HWND Grid_hWnd)
{
	int iItem = 0;
	int iTempSz = 0;
	int iChecked = 0;
	int iImage = 0;
	bool bGotPK = true;

	char sTemp[1024];
	
	CSQL cSQL;
	CRecordSet rsTemp;
	
	LV_ITEM MyLVItem;
	memset(&MyLVItem, 0, sizeof(MyLVItem));

    int iLVStyle = LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT | LVS_EX_CHECKBOXES;
    SendMessage(Grid_hWnd, (UINT)LVM_SETEXTENDEDLISTVIEWSTYLE, (WPARAM)0, (LPARAM)iLVStyle);

	if(!cSQL.Connect(gsSQLDriver, gsSQLServer, gsSQLUserID, gsSQLPassword, gsSQLDatabase))
	{
		MessageBox(Replication_hWnd, "Failed to connect to the SQL server.", gsTitleCaption, NULL);
		return false;
	}

	strcpy(sTemp, "SELECT A.Name,"
		" IsNull((SELECT top 1 SysObjects.Name"
		" FROM SysObjects, SysIndexes, SysIndexKeys, SysColumns"
		" WHERE SysObjects.xtype = 'PK'"
		" AND SysObjects.Name = SysIndexes.Name AND SysIndexes.IndId = SysIndexKeys.IndId"
		" AND SysIndexes.ID = SysIndexKeys.ID AND SysIndexKeys.ColId = SysColumns.ColId"
		" AND SysObjects.Parent_Obj = SysColumns.ID AND SysObjects.Parent_Obj = Object_Id(A.Name)), ''),"
		" Count(B.ID)"
		" FROM SysObjects AS A, SysObjects AS B"
		" WHERE A.xType = 'U' AND LEFT(A.NAME, 8) <> 'SQLExch_'"
		" AND A.ID *= B.Parent_Obj AND LEFT(B.NAME, 8) = 'SQLExch_'"
		" AND A.Name <> 'dtProperties'"
		//" AND A.ID IN (SELECT ID FROM SysColumns WHERE SysColumns.ColStat = 1)""
		" GROUP BY A.Name, A.CrDate, A.RefDate"
		" ORDER BY A.Name");

	cSQL.Execute(sTemp, &rsTemp);

	while(rsTemp.Fetch())
	{
		rsTemp.sColumnEx(1, sTemp, sizeof(sTemp), &iTempSz);
		MyLVItem.pszText  = sTemp;
        MyLVItem.mask     = LVIF_TEXT;
        MyLVItem.iSubItem = 0;
		MyLVItem.iItem    = iItem;
        ListView_InsertItem(Grid_hWnd, &MyLVItem);

		rsTemp.sColumnEx(2, sTemp, sizeof(sTemp), &iTempSz);
        MyLVItem.pszText  = sTemp;
        MyLVItem.mask     = LVIF_TEXT;
        MyLVItem.iSubItem = 1;
		MyLVItem.iItem    = iItem;
        ListView_SetItem(Grid_hWnd, &MyLVItem);

		if(strlen(sTemp) > 0)
		{
			bGotPK = true;
		}
		else {
			bGotPK = false;
		}

		if(rsTemp.lColumn(3) > 0)
		{
			ListView_SetCheckState(Grid_hWnd, iItem, TRUE);
			iChecked = 1;
		}
		else{
			ListView_SetCheckState(Grid_hWnd, iItem, FALSE);
			iChecked = 0;
		}

        if(iChecked == 1) {
			strcpy(sTemp, "Replicating.");
			iImage = 2;
		}
		else if(bGotPK) {
			strcpy(sTemp, "Not Replicating.");
			iImage = 0;
		}
		else{
			strcpy(sTemp, "Cannot Replicate.");
			iImage = 1;
		}

		MyLVItem.mask = LVIF_PARAM|LVIF_IMAGE;
        MyLVItem.iSubItem = 0;
        MyLVItem.iImage   = iImage;
		MyLVItem.lParam   = iImage;
		MyLVItem.iItem    = iItem;
        ListView_SetItem(Grid_hWnd, &MyLVItem);

        MyLVItem.pszText  = sTemp;
        MyLVItem.mask     = LVIF_TEXT;
        MyLVItem.iSubItem = 2;
		MyLVItem.iItem    = iItem;
        ListView_SetItem(Grid_hWnd, &MyLVItem);

		iItem++;
	}

	cSQL.Disconnect();

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI ProcessTablesGrid_Thread(LPVOID lpData)
{
	HWND CmdApply_hWnd = GetDlgItem(Replication_hWnd, ID_APPLY);
	HWND CmdClose_hWnd = GetDlgItem(Replication_hWnd, ID_CANCEL);
	HWND CmdAll_hWnd = GetDlgItem(Replication_hWnd, ID_CHKALL);
	HWND CmdNone_hWnd = GetDlgItem(Replication_hWnd, ID_CHKNONE);

	EnableWindow(CmdApply_hWnd, FALSE);
	EnableWindow(CmdClose_hWnd, FALSE);
	EnableWindow(CmdAll_hWnd, FALSE);
	EnableWindow(CmdNone_hWnd, FALSE);

	ProcessTablesGrid(TablesList_hWnd);

	EnableWindow(CmdClose_hWnd, TRUE);

	bProcessing = false;

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ProcessTablesGrid(HWND Grid_hWnd)
{
    int iRow = 0;
	int iParam = 0;
	int iItems = ListView_GetItemCount(Grid_hWnd);
	char sTableName[1024];

	LV_ITEM MyLVItem;

	CSQL cSQL;

	CStatusDlg MyStatDlg;

	MyStatDlg.Load(Replication_hWnd, "Creating replications.", IDI_MAIN, false);
	EnableWindow(Replication_hWnd, FALSE);
	MyStatDlg.Show();

	if(!cSQL.Connect(gsSQLDriver, gsSQLServer, gsSQLUserID, gsSQLPassword, gsSQLDatabase))
	{
		MessageBox(Replication_hWnd, "Failed to connect to the SQL server.", gsTitleCaption, NULL);
		return false;
	}

	MyStatDlg.SetProgressRange(0, iItems);

	Sleep(1500);

	MyStatDlg.SetText("Updating replication settings.");

	while(iRow < iItems)
    {
        memset(&MyLVItem, 0, sizeof(MyLVItem));
		MyLVItem.cchTextMax = sizeof(sTableName);
		MyLVItem.pszText    = sTableName;
		MyLVItem.mask       = LVIF_PARAM|LVIF_TEXT;
        MyLVItem.iSubItem   = 0;
		MyLVItem.iItem      = iRow;

		if(ListView_GetItem(Grid_hWnd, &MyLVItem))
		{
			iParam = MyLVItem.lParam;

			/*
				lParam:
					0: Not (But Can) replicating.
					1: Cannot replicate.
					2: Currently replicating.
			*/

			//If the item is checked.
			if(ListView_GetCheckState(Grid_hWnd, iRow))
			{
				//If the item was previously unchecked.
				if(iParam == 0)
				{
					if(CreateReplicationEx(&cSQL, gsReplicationDB, gsSQLDatabase, gsDefaultDBO, sTableName, Grid_hWnd, 2, iRow))
					{
						SetStatus(Grid_hWnd, 2, iRow, "Create OK.");
					}
					else SetStatus(Grid_hWnd, 2, iRow, "Create Failed!");
				}
			}
			else { //If the item is unchecked.

				//If the item was previously checked.
				if(iParam == 2)
				{
					SetStatus(Grid_hWnd, 2, iRow, "Dropping Triggers.");
					if(DropReplicationTriggers(&cSQL, gsSQLDatabase, sTableName))
					{
						SetStatus(Grid_hWnd, 2, iRow, "Dropping tables.");
						if(DropReplicationTables(&cSQL, gsReplicationDB, gsSQLDatabase, gsDefaultDBO, sTableName))
						{
							SetStatus(Grid_hWnd, 2, iRow, "Drop OK.");
						}
						else SetStatus(Grid_hWnd, 2, iRow, "Drop Failed!");
					}
					else SetStatus(Grid_hWnd, 2, iRow, "Drop Failed!");
				}
			}
		}
        iRow++;

		MyStatDlg.SetProgressPos(iRow);
		Sleep(1);
    }

	GenerateReplicationScripts(&MyStatDlg, gsReplicationDB, gsSQLDatabase, gsDefaultDBO, true);

	cSQL.Disconnect();

	MyStatDlg.SetText("Complete.");

	MyStatDlg.SetButtonText("Ok");

	MyStatDlg.EnableButton();

	EnableWindow(Replication_hWnd, TRUE);

	while(MyStatDlg.IsDlgVisible())
	{
		Sleep(1);
	}


	MyStatDlg.Unload();

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

